/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.registration;

import java.util.List;
import java.util.function.Function;
import net.createmod.ponder.api.registration.MultiTagBuilder;
import net.createmod.ponder.api.registration.PonderTagRegistrationHelper;
import net.createmod.ponder.api.registration.TagBuilder;
import net.createmod.ponder.foundation.PonderTag;
import net.createmod.ponder.foundation.registration.GenericMultiTagBuilder;
import net.createmod.ponder.foundation.registration.GenericPonderTagRegistrationHelper;
import net.createmod.ponder.foundation.registration.PonderLocalization;
import net.createmod.ponder.foundation.registration.PonderTagBuilder;
import net.createmod.ponder.foundation.registration.PonderTagRegistry;
import net.minecraft.class_2960;

public class DefaultPonderTagRegistrationHelper
implements PonderTagRegistrationHelper<class_2960> {
    protected String namespace;
    protected PonderTagRegistry tagRegistry;
    protected PonderLocalization localization;

    public DefaultPonderTagRegistrationHelper(String namespace, PonderTagRegistry tagRegistry, PonderLocalization localization) {
        this.namespace = namespace;
        this.tagRegistry = tagRegistry;
        this.localization = localization;
    }

    @Override
    public <T> PonderTagRegistrationHelper<T> withKeyFunction(Function<T, class_2960> keyGen) {
        return new GenericPonderTagRegistrationHelper<T>(this, keyGen);
    }

    @Override
    public TagBuilder registerTag(class_2960 location) {
        return new PonderTagBuilder(location, this::finishTagRegister);
    }

    @Override
    public TagBuilder registerTag(String id) {
        return new PonderTagBuilder(new class_2960(this.namespace, id), this::finishTagRegister);
    }

    private void finishTagRegister(PonderTagBuilder builder) {
        this.localization.registerTag(builder.id, builder.title, builder.description);
        PonderTag tag = new PonderTag(builder.id, builder.textureIconLocation, builder.itemIcon, builder.mainItem);
        this.tagRegistry.registerTag(tag);
        if (builder.addToIndex) {
            this.tagRegistry.listTag(tag);
        }
    }

    @Override
    public void addTagToComponent(class_2960 component, class_2960 tag) {
        this.tagRegistry.addTagToComponent(tag, component);
    }

    @Override
    public MultiTagBuilder.Tag<class_2960> addToTag(class_2960 tag) {
        return new GenericMultiTagBuilder.Tag(new GenericMultiTagBuilder(), this, List.of(tag));
    }

    @Override
    public MultiTagBuilder.Tag<class_2960> addToTag(class_2960 ... tags) {
        return new GenericMultiTagBuilder.Tag(new GenericMultiTagBuilder(), this, List.of(tags));
    }

    @Override
    public MultiTagBuilder.Component addToComponent(class_2960 component) {
        return new GenericMultiTagBuilder.Component(new GenericMultiTagBuilder(), this, List.of(component));
    }

    @Override
    public MultiTagBuilder.Component addToComponent(class_2960 ... components) {
        return new GenericMultiTagBuilder.Component(new GenericMultiTagBuilder(), this, List.of(components));
    }
}

